varying vec2 		texcoord;
uniform sampler2D 	tex;
uniform sampler2D	vel;
vec4 				color;

void main()
{
	color=texture2D(tex,texcoord);

	// MOTION BLUR	//////////////////////////////////
	vec3 v=texture2D(vel, texcoord).rgb;
	vec2 v2d=v.xy;
	float vlen=length(v.xy);
	if(vlen>0.0) v.xy=normalize(v.xy)*min(vlen,0.008);

	v.z+=0.1;
	float count=1.0;
	float dd=0.0;

	// Sample the color buffer along the velocity vector.
	vec4 currentColor = texture2D(tex, texcoord+v.xy*1.5);
	float d2=-texture2D(vel, texcoord+v.xy*1.5).z;
	dd=clamp((d2+v.z),0.0,1.0);
	color+=currentColor*dd;
	count+=dd;

	currentColor = texture2D(tex, texcoord-v.xy*1.5);
	d2=-texture2D(vel, texcoord-v.xy*1.5).z;
	dd=clamp((d2+v.z),0.0,1.0);
	color+=currentColor*dd;
	count+=dd;

	currentColor = texture2D(tex, texcoord+v.xy*3.0);
	d2=-texture2D(vel, texcoord+v.xy*3.0).z;
	dd=clamp((d2+v.z),0.0,1.0);
	color+=currentColor*dd;
	count+=dd;

	currentColor = texture2D(tex, texcoord-v.xy*3.0);
	d2=-texture2D(vel, texcoord-v.xy*3.0).z;
	dd=clamp((d2+v.z),0.0,1.0);
	color+=currentColor*dd;
	count+=dd;

	currentColor = texture2D(tex, texcoord+v.xy*4.5);
	d2=-texture2D(vel, texcoord+v.xy*4.5).z;
	dd=clamp((d2+v.z),0.0,1.0);
	color+=currentColor*dd;
	count+=dd;

	currentColor = texture2D(tex, texcoord-v.xy*4.5);
	d2=-texture2D(vel, texcoord-v.xy*4.5).z;
	dd=clamp((d2+v.z),0.0,1.0);
	color+=currentColor*dd;
	count+=dd;

	currentColor = texture2D(tex, texcoord+v.xy*6.0);
	d2=-texture2D(vel, texcoord+v.xy*6.0).z;
	dd=clamp((d2+v.z),0.0,1.0);
	color+=currentColor*dd;
	count+=dd;

	currentColor = texture2D(tex, texcoord-v.xy*6.0);
	d2=-texture2D(vel, texcoord-v.xy*6.0).z;
	dd=clamp((d2+v.z),0.0,1.0);
	color+=currentColor*dd;
	count+=dd;

	/////////////////////////////////////////////////////////

	currentColor = texture2D(tex, texcoord+v.xy*0.75);
	d2=-texture2D(vel, texcoord+v.xy*0.75).z;
	dd=clamp((d2+v.z),0.0,1.0);
	color+=currentColor*dd;
	count+=dd;

	currentColor = texture2D(tex, texcoord-v.xy*0.75);
	d2=-texture2D(vel, texcoord-v.xy*0.75).z;
	dd=clamp((d2+v.z),0.0,1.0);
	color+=currentColor*dd;
	count+=dd;

	currentColor = texture2D(tex, texcoord+v.xy*2.25);
	d2=-texture2D(vel, texcoord+v.xy*2.25).z;
	dd=clamp((d2+v.z),0.0,1.0);
	color+=currentColor*dd;
	count+=dd;

	currentColor = texture2D(tex, texcoord-v.xy*2.25);
	d2=-texture2D(vel, texcoord-v.xy*2.25).z;
	dd=clamp((d2+v.z),0.0,1.0);
	color+=currentColor*dd;
	count+=dd;

	currentColor = texture2D(tex, texcoord+v.xy*3.75);
	d2=-texture2D(vel, texcoord+v.xy*3.75).z;
	dd=clamp((d2+v.z),0.0,1.0);
	color+=currentColor*dd;
	count+=dd;

	currentColor = texture2D(tex, texcoord-v.xy*3.75);
	d2=-texture2D(vel, texcoord-v.xy*3.75).z;
	dd=clamp((d2+v.z),0.0,1.0);
	color+=currentColor*dd;
	count+=dd;

	currentColor = texture2D(tex, texcoord+v.xy*5.25);
	d2=-texture2D(vel, texcoord+v.xy*5.25).z;
	dd=clamp((d2+v.z),0.0,1.0);
	color+=currentColor*dd;
	count+=dd;

	currentColor = texture2D(tex, texcoord-v.xy*5.25);
	d2=-texture2D(vel, texcoord-v.xy*5.25).z;
	dd=clamp((d2+v.z),0.0,1.0);
	color+=currentColor*dd;
	count+=dd;

	//////////////////////////////////////////////////
	
	color/=count;
	gl_FragColor.xyz = color.xyz;
}
